#include "matlib.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct scalar {
  double value;
};

struct vector {
  int n;
  double *elements;
};

struct matrix_dense {
  int n;
  int m;
  double* elements;
};

struct matrix_csr {
  int n;
  int m;
  int nnz; // Number of nonzero entries.
  double *v; // Nonzero values, of length nnz.
  int *v_col; // Column of each value, of length nnz.
  int *row_start; // For each row number, offset in v where that row
                  // starts.
};

void isAlmostEqual(float x, float y){
    if (fabs(x-y) < 0.00001){
        printf("True\n");
    }else{
        printf("False\n");
    }
}

void vectorIsAlmostEqual(struct vector* x, struct vector* y){
    for(int i = 0; i<x->n; i++){
        if (fabs(x->elements[i] - y->elements[i]) > 0.00001){
            printf("False\n");
            return;
        }
    }
    printf("True\n");
}

void printMatrixDense(struct matrix_dense* X){
    int rows = matrix_dense_n(X);
    int cols = matrix_dense_m(X);

    for (int i = 0; i < rows; i++) {
        for (int j = 0; j < cols; j++) {
            if (j != 0) {
                printf(" ");
            }
            printf("%f", matrix_dense_idx(X, i, j));
        }
        printf("\n");
    }
}
void printvector(struct vector* v){
    for (int i = 0; i < v->n; i++){
        printf("%f \n", v->elements[i]);
    }
}

int main() {
    
    printf("--------Testing mul_vv--------\n");
    printf("Left side is from C code, right side is result from maple\n");
    struct vector* x = read_vector("test_files/6vectest.vdns");

    struct scalar* z = mul_vv(x, x);
    
    printf("%f = 1.38358408921400011: ", z->value);
    isAlmostEqual(z->value, 1.38358408921400011);

    
    struct vector* y = read_vector("test_files/15vectest.vdns");
    z = mul_vv(y, y);
    printf("%f = 4.83244353623299983: ", z->value);
    isAlmostEqual(z->value, 4.83244353623299983);
    

    struct vector* q = read_vector("test_files/40vectest.vdns");
    z = mul_vv(q, q);
    printf("%f = 14.7840543979929997: ", z->value);
    isAlmostEqual(z->value, 14.7840543979929997);

    struct vector* k = read_vector("test_files/100vectest.vdns");
    z = mul_vv(k, k);
    printf("%f = 32.5859365740450002: ", z->value);
    isAlmostEqual(z->value, 32.5859365740450002);

    struct vector* k2 = read_vector("test_files/100vectest2.vdns");
    z = mul_vv(k, k2);
    printf("%f = 24.6344592219770000: ", z->value);
    isAlmostEqual(z->value, 24.6344592219770000);

    printf("\nTest for 2 vectors of different dimension, should give NULL: ");
    if (mul_vv(x, y) == NULL){
        printf("Is NULL");
    }else{
        printf("Is not NULL");
    }
    printf("\n");


//mul_mv
    printf("\n");
    printf("--------Testing mul_mv--------\n");
    printf("Using results from maple\n");
    struct vector* v_maple = malloc(sizeof(struct vector));
    v_maple->n = 3;
    double arr[3] = {1.199135053608, 1.7374803886189998, 1.273154264102};
    v_maple->elements = arr;
    
    struct matrix_dense* m1 =read_matrix_dense("test_files/3x6matrixtest.mdns");
    struct vector *res = mul_mv(m1, x);
    printf("3x6 matrix * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);


    struct matrix_dense* m2 =read_matrix_dense("test_files/3x15matrixtest.mdns");
    double arr1[3] = {4.31120804588000, 3.71282105961600, 4.49679200298900};
    v_maple->elements = arr1;
    v_maple->n = 3;

    res = mul_mv(m2, y);
    printf("3x15 matrix * 15x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    struct matrix_dense* m3 =read_matrix_dense("test_files/6x6matrixtest.mdns");

    double arr2[6] = {1.314429072976, 1.296897965434, 1.465289061219, 1.678096936479, 0.9045430467159999, 1.051839059949};
    v_maple->elements = arr2;
    v_maple->n = 6;

    res = mul_mv(m3, x);
    printf("6x6 matrix * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    printf("\nTest for wrong dimensions, should give NULL: ");
    if (mul_mv(m3, y) == NULL){
        printf("Is NULL");
    }else{
        printf("Is not NULL");
    }
    printf("\n");

    printf("\n");
    printf("--------Testing mul_mTv--------\n");

    struct vector* vec3 = read_vector("test_files/3vectest.vdns");
    res = mul_mTv(m1, vec3);
    double arr3[6] = {1.04838944583, 1.038461351792, 0.77761753547, 0.541070008352, 0.622756724354, 0.395203824078};
    v_maple->elements = arr3;
    v_maple->n = 6;
    printf("3x6 matrix^T * 3x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);


    res = mul_mTv(m2, vec3);
    double arr4[15] = {.661313263478, .732652795514, .53189032998, .415863320822, .83346843554, .955985431744, .623915988464, .665417170544, .870387842706, 1.063696875264, .48809569495, .608962057242, .924295966062, .51901431356, .642664592184};
    v_maple->elements = arr4;
    v_maple->n = 15;
    printf("3x15 matrix^T * 3x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    res = mul_mTv(m3, x);
    double arr5[6] = {1.390243749838, 0.9047567557689999, 1.9156642055389999, 1.665246416474, 1.462481546084, 1.098609606469};
    v_maple->elements = arr5;
    v_maple->n = 6;
    printf("6x6 matrix^T * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    
    printf("\nTest for wrong dimensions, should give NULL: ");
    if (mul_mTv(m3, y) == NULL){
        printf("Is NULL");
    }else{
        printf("Is not NULL");
    }
    printf("\n");

    printf("\n");
    printf("--------Testing mul_spmv--------\n");

    struct matrix_csr *mc1 = read_matrix_csr("test_files/3x6matrixtest.mcsr");
    res = mul_spmv(mc1, x);
    double arr6[3] = {0.14660115617400002, 0.058209912503, 0.9634079169559999};
    v_maple->elements = arr6;
    v_maple->n = 6;
    printf("3x6 matrix * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    struct matrix_csr *mc2 = read_matrix_csr("test_files/3x15matrixtest.mcsr");
    res = mul_spmv(mc2, y);
    double arr7[3] = {2.2090373885920003, 1.342215917022, 2.589781778278};
    v_maple->elements = arr7;
    v_maple->n = 3;
    printf("3x15 matrix * 15x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    struct matrix_csr *mc3 = read_matrix_csr("test_files/6x6matrixtest.mcsr");
    res = mul_spmv(mc3, x);
    double arr8[6] = {0.562765066837, 0.430681380569, 0.455500541416, 0.208158942713, 0.452436258613, 0.505915813877};
    v_maple->elements = arr8;
    v_maple->n = 6;
    printf("6x6 matrix * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    printf("\nTest for wrong dimensions, should give NULL: ");
    if (mul_mTv(m3, y) == NULL){
        printf("Is NULL");
    }else{
        printf("Is not NULL");
    }

    printf("\n");
    printf("--------Testing mul_spmTv--------\n");

    res = mul_spmTv(mc1, vec3);
    double arr9[6] = {0.074187250172, 0.21048184194199998, 0.313215747072, 0.09134988709, 0.036734695998, 0.187996172118};
    v_maple->elements = arr9;
    v_maple->n = 6;
    printf("3x6 matrix^T * 3x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);


    res = mul_spmTv(mc2, vec3);
    double arr10[15] = {.125580371416,.282078718658,.183455715086,0.,0.,.179079351808,.648099598718,.73754053868,.355486628522,.513350316136,.40009464614,.556155064174,.398507059194,0.,0.};
    v_maple->elements = arr10;
    v_maple->n = 15;
    printf("3x15 matrix^T * 3x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    res = mul_spmTv(mc3, x);
    double arr11[6] = {0.13877521072399998, 1.444919429104, 0.770702075736, 0.176365508845, 0.017851242585, 0.14451079813300002};
    v_maple->elements = arr11;
    v_maple->n = 6;
    printf("6x6 matrix^T * 6x1 vector: ");
    vectorIsAlmostEqual(res, v_maple);

    printf("\nTest for wrong dimensions, should give NULL: ");
    if (mul_mTv(m3, y) == NULL){
        printf("Is NULL");
    }else{
        printf("Is not NULL");
    }
    printf("\n");

    
    


    free_vector(vec3);
    free_vector(x);
    free_vector(y);
    free_vector(q);
    free_vector(k);
    free_vector(k2);
    free_scalar(z);
    free_vector(res);
    free_matrix_dense(m1);
    free_matrix_dense(m2);
    free_matrix_dense(m3);
    free_matrix_csr(mc1);
    free_matrix_csr(mc2);
    free_matrix_csr(mc3);
}
